/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.pa.ar;

import com.ibm.hwmca.base.pa.ar.HardwareAnalysis;
import com.ibm.hwmca.base.pa.ar.HardwareEvent0405Rule;
import com.ibm.hwmca.base.pa.ar.HardwareEvent0405RuleBase;
import com.ibm.hwmca.base.pa.ar.HardwareEvent0405XMLParser;
import com.ibm.hwmca.base.pa.ar.HardwareEvent0406Rule;
import com.ibm.hwmca.base.pa.ar.HardwareEvent0406RuleBase;
import com.ibm.hwmca.base.pa.ar.HardwareEvent0406XMLParser;
import com.ibm.hwmca.base.pa.ar.HardwareEvent0408Rule;
import com.ibm.hwmca.base.pa.ar.HardwareEvent0408RuleBase;
import com.ibm.hwmca.base.pa.ar.HardwareEvent0408XMLParser;
import com.ibm.hwmca.base.pa.event.HardwareDataEventClass04;
import com.ibm.hwmca.base.pa.event.HardwareFailuresClass04;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEvent;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEventListener;
import com.ibm.hwmca.fw.util.HexString;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;

public class HardwareAnalysisClass04
extends HardwareAnalysis
implements ProblemAnalysisEventListener {
    private static final String TRACE_MASKT = "XPAH04AT";
    private static final String TRACE_MASKF = "XPAH04AF";
    private static final String TRACE_MASKD = "XPAH04AD";
    private String[] message_number = new String[]{new String(), new String(), new String(), new String(), new String(), new String()};
    public static String UNKNOWN_MESSAGE = "UNKNOWN_MESSAGE";
    private HardwareEvent0405RuleBase rb = null;
    private HardwareEvent0405Rule rule = null;
    private String ruleKey = "2486";
    private HardwareDataEventClass04 ourEvent = null;

    public HardwareAnalysisClass04() {
        Trace.trace(TRACE_MASKD, "<-> ctor");
    }

    public void analyze(ProblemAnalysisEvent event) {
        Trace.trace(TRACE_MASKD, "--> analyze()");
        super.analyze(event);
        this.ourEvent = (HardwareDataEventClass04)event;
        switch (this.getEventType()) {
            case 2: {
                this.handleType02();
                break;
            }
            case 3: {
                this.handleType03();
                break;
            }
            case 5: {
                this.handleType05();
                break;
            }
            case 6: {
                this.handleType06();
                break;
            }
            case 7: {
                this.handleType07();
                break;
            }
            case 8: {
                this.handleType08();
                break;
            }
            case 9: {
                this.handleType09();
                break;
            }
            case 11: {
                this.handleType0B();
                break;
            }
            case 15: {
                this.handleType0F();
                break;
            }
            default: {
                Trace.trace(TRACE_MASKF, " Invalid ff value = " + this.getEventType());
                short someRc = 0;
                new FrameworkLog(new FrameworkClassLogInfo(92, "HWAnalysis04"), someRc).log();
                Trace.trace(TRACE_MASKF, "End ff value = invalid.");
            }
        }
        this.finishAndReport(this.ourEvent, this.problem, this.incident);
        Trace.trace(TRACE_MASKD, "<-- analyze()");
    }

    private void handleType02() {
        Trace.trace(TRACE_MASKF, " ff = 0x02");
        Trace.trace(TRACE_MASKF, " error id = " + this.getErrorId());
        Trace.trace(TRACE_MASKF, " Begin with case statement");
        switch (this.getErrorId()) {
            case 28528: 
            case 28531: {
                Trace.trace(TRACE_MASKF, " case hit b000004");
                this.getProblem().setRefcode("B0001004");
                break;
            }
            case 28529: 
            case 28532: {
                Trace.trace(TRACE_MASKF, " case hit b000005");
                this.getProblem().setRefcode("B0001005");
                break;
            }
            case 28530: 
            case 28533: 
            case 28534: 
            case 28535: 
            case 28536: 
            case 28537: {
                Trace.trace(TRACE_MASKF, " case hit b000006");
                this.getProblem().setRefcode("B0001006");
                break;
            }
            case 28538: {
                Trace.trace(TRACE_MASKF, " case hit b000007");
                this.getProblem().setRefcode("B0001007");
                break;
            }
            case 28539: {
                Trace.trace(TRACE_MASKF, " case hit b000008");
                this.getProblem().setRefcode("B0001008");
                break;
            }
            default: {
                Trace.trace(TRACE_MASKF, " default");
                this.getProblem().setRefcode("B0001003");
            }
        }
        Trace.trace(TRACE_MASKF, " done with case statement");
        this.getProblem().setExtension("00000000");
        this.getProblem().setCategory(1);
        this.getProblem().setDescription(1637);
        this.getProblem().setService("S");
        this.getProblem().setTransmit(false);
        this.getIncident().setPriority(65.0f);
        Trace.trace(TRACE_MASKF, " abpit tp setLogId");
        Trace.trace(TRACE_MASKF, ": End ff = 0x02");
    }

    private void handleType03() {
        Trace.trace(TRACE_MASKF, ": ff = 0x03");
        Trace.trace(TRACE_MASKF, ": Event TPHCONN = " + this.ourEvent.getTphconn());
        if (this.ourEvent.getTphconn() == -15) {
            Trace.trace(TRACE_MASKF, ": PA is failing SSI requestor.");
            switch (this.getErrorId()) {
                case 28528: 
                case 28531: {
                    this.getProblem().setRefcode("B0001004");
                    break;
                }
                case 28529: 
                case 28532: {
                    this.getProblem().setRefcode("B0001005");
                    break;
                }
                case 28530: 
                case 28533: 
                case 28534: 
                case 28535: 
                case 28536: 
                case 28537: {
                    this.getProblem().setRefcode("B0001006");
                    break;
                }
                case 28538: {
                    this.getProblem().setRefcode("B0001007");
                    break;
                }
                case 28539: {
                    this.getProblem().setRefcode("B0001008");
                    break;
                }
                default: {
                    this.getProblem().setRefcode("B0001001");
                }
            }
            this.getProblem().setService("S");
            this.getIncident().setPriority(66.0f);
        } else {
            Trace.trace(TRACE_MASKF, ": Failing SSI requestor is NOT PA.");
            switch (this.getErrorId()) {
                case 28528: 
                case 28531: {
                    this.getProblem().setRefcode("B0001004");
                    this.getProblem().setProblemType("2");
                    break;
                }
                case 28529: 
                case 28530: 
                case 28532: 
                case 28533: {
                    this.getProblem().setRefcode("B0001005");
                    this.getProblem().setProblemType("2");
                    break;
                }
                case 28534: 
                case 28535: 
                case 28536: 
                case 28537: {
                    this.getProblem().setRefcode("B0001006");
                    this.getProblem().setProblemType("2");
                    break;
                }
                case 28538: {
                    this.getProblem().setRefcode("B0001007");
                    this.getProblem().setProblemType("2");
                    break;
                }
                case 28539: {
                    this.getProblem().setRefcode("B0001008");
                    this.getProblem().setProblemType("2");
                    break;
                }
                default: {
                    this.getProblem().setRefcode("B0001002");
                }
            }
            this.getProblem().setService("Y");
            this.getProblem().addProblemStatement(new BaseMessageText("XPA2402"));
            this.getProblem().addRepairImpactStatement(new BaseMessageText("XPA2438"));
            this.getProblem().addCorrectiveActionStatement(new BaseMessageText("XPA2900"));
            this.getIncident().setPriority(72.0f);
        }
        this.getProblem().setExtension("00000000");
        this.getProblem().setTransmit(false);
        this.getProblem().setCategory(1);
        this.getProblem().setDescription(1637);
        Trace.trace(TRACE_MASKF, ": End ff = 0x03");
    }

    private void handleType05() {
        Trace.trace(TRACE_MASKF, ": log5->tpcfname =" + this.ourEvent.getTpcfname());
        Trace.trace(TRACE_MASKF, ": log5->tpmmnumb =" + this.ourEvent.getTpmmnumb());
        Trace.trace(TRACE_MASKF, ": message_number = " + this.ourEvent.getTpmmnumb());
        String xmlFileToUse = new String();
        String baseFilePath = HardwareAnalysisClass04.getBaseFilePath("paconfig");
        if (this.ourEvent.getTpcfname().indexOf("ACS") != -1) {
            xmlFileToUse = baseFilePath + "IQYP33CA.XML";
        } else if (this.ourEvent.getTpcfname().indexOf("MAC") != -1) {
            xmlFileToUse = baseFilePath + "IQYP33CM.XML";
        } else {
            FrameworkLog microCodeEvent = new FrameworkLog(new FrameworkClassLogInfo(92, "04Analysis"), Short.parseShort("0"), 1104, 0);
            microCodeEvent.log();
            Trace.trace(TRACE_MASKT, ": <- HardwareAnalysis04");
            return;
        }
        try {
            this.rb = HardwareEvent0405XMLParser.parseXML(xmlFileToUse);
            if (this.rb != null) {
                Trace.trace(TRACE_MASKD, "have an RB");
            } else {
                Trace.trace(TRACE_MASKD, "do not have an RB");
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKD, "Exception parsing file");
        }
        this.rule = this.rb.findRule(this.ourEvent.getTpmmnumb());
        if (this.rule != null) {
            Trace.trace(TRACE_MASKD, "rule based off of Key  = " + this.rule.getPriorityAsFloat());
        } else {
            Trace.trace(TRACE_MASKD, "could not find rule based off of key " + this.ourEvent.getTpmmnumb());
        }
        if (this.rule == null) {
            FrameworkLog microCodeEvent = new FrameworkLog(new FrameworkClassLogInfo(92, "04Analysis"), this.comp_rc, 1107, 0);
            microCodeEvent.log();
            Trace.trace(TRACE_MASKT, ": <- HardwareAnalysis04");
            return;
        }
        if (this.rule.getPriority() == null) {
            FrameworkLog microCodeEvent = new FrameworkLog(new FrameworkClassLogInfo(92, "04Analysis"), 5, 1106, 0);
            microCodeEvent.log();
            Trace.trace(TRACE_MASKT, ": <- HardwareAnalysis04");
            return;
        }
        this.getIncident().setPriority(this.rule.getPriorityAsFloat());
        if (this.rule.getService() == null) {
            FrameworkLog microCodeEvent = new FrameworkLog(new FrameworkClassLogInfo(92, "04Analysis"), 7, 1106, 0);
            microCodeEvent.log();
            Trace.trace(TRACE_MASKT, ": <- HardwareAnalysis04");
            return;
        }
        this.getProblem().setService(this.rule.getService());
        if (this.rule.getTransmit() == null) {
            FrameworkLog microCodeEvent = new FrameworkLog(new FrameworkClassLogInfo(92, "04Analysis"), 8, 1106, 0);
            microCodeEvent.log();
            Trace.trace(TRACE_MASKT, ": <- HardwareAnalysis04");
            return;
        }
        this.getProblem().setTransmit(this.rule.isTransmit());
        if (this.rule.getMessages() == null) {
            FrameworkLog microCodeEvent = new FrameworkLog(new FrameworkClassLogInfo(92, "04Analysis"), 4, 1106, 0);
            microCodeEvent.log();
            Trace.trace(TRACE_MASKT, ": <- HardwareAnalysis04");
            return;
        }
        if (this.rule.getMessages().indexOf("3126") == 0) {
            this.getProblem().setDisableRepair(true);
            this.getProblem().setDescription(HardwareFailuresClass04.EMP_MSG_SECURITY);
        } else {
            ArrayList messages = this.rule.getMessageList();
            HardwareAnalysisClass04.setMessages(this.getProblem(), messages);
            this.getProblem().setDescription(1637);
        }
        if (this.ourEvent.getTpcfname().indexOf("ACS") == 0) {
            this.getProblem().setRefcode("B001");
        } else if (this.ourEvent.getTpcfname().indexOf("MAC") == 0) {
            this.getProblem().setRefcode("B002");
        } else {
            FrameworkLog microCodeEvent = new FrameworkLog(new FrameworkClassLogInfo(92, "04Analysis"), Short.parseShort("1"), 1104, 0);
            microCodeEvent.log();
            Trace.trace(TRACE_MASKT, ": <- HardwareAnalysis04");
            return;
        }
        this.getProblem().setRefcode(this.getProblem().getRefcode() + this.ourEvent.getTpmmnumb());
        this.getProblem().setExtension("00000000");
        this.getProblem().setCategory(1);
        Trace.trace(TRACE_MASKF, ": ff = 0x05");
    }

    private void handleType0F() {
        this.getIncident().getProblem().setServiceableEventText(new LocalizableText(new String((byte[])this.dataLog.getLogBlock((byte)3).getData())));
        Trace.trace(TRACE_MASKF, "==> handleType0F");
        Trace.trace(TRACE_MASKF, ": errorId" + this.ourEvent.getErrorId());
        String xmlFileToUse = new String();
        String baseFilePath = HardwareAnalysisClass04.getBaseFilePath("paconfig");
        xmlFileToUse = baseFilePath + "IQYP33CA.XML";
        try {
            this.rb = HardwareEvent0405XMLParser.parseXML(xmlFileToUse);
            if (this.rb != null) {
                Trace.trace(TRACE_MASKD, "have an RB");
            } else {
                Trace.trace(TRACE_MASKD, "do not have an RB");
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKD, "Exception parsing file");
        }
        this.rule = this.rb.findRule(HexString.toHex(this.ourEvent.getErrorId(), true));
        if (this.rule != null) {
            Trace.trace(TRACE_MASKD, "rule based off of Key  = " + this.rule.getPriorityAsFloat());
        } else {
            Trace.trace(TRACE_MASKD, "could not find rule based off of key " + HexString.toHex(this.ourEvent.getErrorId(), true));
        }
        if (this.rule == null) {
            FrameworkLog microCodeEvent = new FrameworkLog(new FrameworkClassLogInfo(92, "04Analysis"), this.comp_rc, 1107, 0);
            microCodeEvent.log();
            Trace.trace(TRACE_MASKT, ": <- HardwareAnalysis04");
            return;
        }
        if (this.rule.getPriority() == null) {
            FrameworkLog microCodeEvent = new FrameworkLog(new FrameworkClassLogInfo(92, "04Analysis"), 5, 1106, 0);
            microCodeEvent.log();
            Trace.trace(TRACE_MASKT, ": <- HardwareAnalysis04");
            return;
        }
        this.getIncident().setPriority(this.rule.getPriorityAsFloat());
        if (this.rule.getService() == null) {
            FrameworkLog microCodeEvent = new FrameworkLog(new FrameworkClassLogInfo(92, "04Analysis"), 7, 1106, 0);
            microCodeEvent.log();
            Trace.trace(TRACE_MASKT, ": <- HardwareAnalysis04");
            return;
        }
        this.getProblem().setService(this.rule.getService());
        if (this.rule.getTransmit() == null) {
            FrameworkLog microCodeEvent = new FrameworkLog(new FrameworkClassLogInfo(92, "04Analysis"), 8, 1106, 0);
            microCodeEvent.log();
            Trace.trace(TRACE_MASKT, ": <- HardwareAnalysis04");
            return;
        }
        this.getProblem().setTransmit(this.rule.isTransmit());
        if (this.rule.getMessages() == null) {
            FrameworkLog microCodeEvent = new FrameworkLog(new FrameworkClassLogInfo(92, "04Analysis"), 4, 1106, 0);
            microCodeEvent.log();
            Trace.trace(TRACE_MASKT, ": <- HardwareAnalysis04");
            return;
        }
        if (this.rule.getMessages().indexOf("3126") == 0) {
            this.getProblem().setDisableRepair(true);
            this.getProblem().setDescription(HardwareFailuresClass04.EMP_MSG_SECURITY);
        } else {
            ArrayList messages = this.rule.getMessageList();
            HardwareAnalysisClass04.setMessages(this.getProblem(), messages);
            this.getProblem().setDescription(1637);
        }
        this.getProblem().setRefcode("B000" + HexString.toHex(this.ourEvent.getErrorId(), true));
        this.getProblem().setExtension("00000000");
        this.getProblem().setCategory(1);
        Trace.trace(TRACE_MASKF, "<==: ff = 0x0F");
    }

    private void handleType06() {
        Trace.trace(TRACE_MASKF, ": ff = 0x06");
        String text = new String();
        Trace.trace(TRACE_MASKD, ":begin initial error case based on errorId" + this.getErrorId());
        switch (this.getErrorId()) {
            case 5: {
                text = "01";
                Trace.trace(TRACE_MASKD, ":match found on CADErrorCodes.XCAD_INVALID_DIAL_CMD" + this.getErrorId());
                break;
            }
            case 12: {
                text = "02";
                Trace.trace(TRACE_MASKD, ":match found on CADErrorCodes.XCAD_FORBIDDEN_CALL" + this.getErrorId());
                break;
            }
            case 14: {
                text = "03";
                Trace.trace(TRACE_MASKD, ":match found on CADErrorCodes.XCAD_INV_COMMAND" + this.getErrorId());
                break;
            }
            case 15: {
                text = "04";
                Trace.trace(TRACE_MASKD, ":match found on  CADErrorCodes.XCAD_INV_MSG_SYNTAX" + this.getErrorId());
                break;
            }
            case 16: {
                text = "05";
                Trace.trace(TRACE_MASKD, ": match found on CADErrorCodes.XCAD_INV_PARM_SYNTAX" + this.getErrorId());
                break;
            }
            case 17: {
                text = "06";
                Trace.trace(TRACE_MASKD, "match found on CADErrorCodes.XCAD_INV_PARM_VALUE" + this.getErrorId());
                break;
            }
            case 30: {
                text = "07";
                Trace.trace(TRACE_MASKD, ":match found on  CADErrorCodes.XCAD_HOT_RESULT_INT" + this.getErrorId());
                break;
            }
            default: {
                Trace.trace(TRACE_MASKF, ": Invalid error_id value = " + this.getErrorId());
                FrameworkLog microCodeEvent = new FrameworkLog(new FrameworkClassLogInfo(92, "04Analysis"), Short.parseShort("0"), this.getErrorId(), 0);
                microCodeEvent.log();
                Trace.trace(TRACE_MASKT, ": <- HardwareAnalysis04");
                return;
            }
        }
        String baseFilePath = HardwareAnalysisClass04.getBaseFilePath("paconfig");
        String xmlFileToUse = baseFilePath + "IQYP33AD.XML";
        HardwareEvent0406RuleBase rb = new HardwareEvent0406RuleBase();
        try {
            rb = HardwareEvent0406XMLParser.parseXML(xmlFileToUse);
            if (rb != null) {
                Trace.trace(TRACE_MASKD, "have an RB");
            } else {
                Trace.trace(TRACE_MASKD, "do not have an RB");
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKD, "Exception parsing file");
            FrameworkLog microCodeEvent = new FrameworkLog(new FrameworkClassLogInfo(92, "Parsing0406"), Short.parseShort("0"), this.getErrorId(), 0);
            microCodeEvent.log();
            return;
        }
        HardwareEvent0406Rule rule = rb.findRule(text);
        if (rule == null) {
            Trace.trace(TRACE_MASKF, ": ADEPT returned NULL refcode.");
            FrameworkLog microCodeEvent = new FrameworkLog(new FrameworkClassLogInfo(92, "Parsing0406"), Short.parseShort("0"), 1, 0);
            microCodeEvent.log();
            Trace.trace(TRACE_MASKT, ": <- HardwareAnalysis0406");
            return;
        }
        if (rule.getRefCode().equals("DEFAULT")) {
            Trace.trace(TRACE_MASKF, ": Unknown refcode.");
            FrameworkLog microCodeEvent = new FrameworkLog(new FrameworkClassLogInfo(92, "04Analysis"), Short.parseShort("0"), 1124, 0);
            microCodeEvent.log();
            Trace.trace(TRACE_MASKT, ": <- HardwareAnalysis0406");
            return;
        }
        this.getProblem().setRefcode(rule.getRefCode());
        if (rule.getExtension() == null) {
            Trace.trace(TRACE_MASKF, ": ADEPT returned NULL extension");
            FrameworkLog microCodeEvent = new FrameworkLog(new FrameworkClassLogInfo(92, "04Analysis"), Short.parseShort("0"), 1123, 0);
            microCodeEvent.log();
            Trace.trace(TRACE_MASKT, ": <- HardwareAnalysis04");
            return;
        }
        this.getProblem().setExtension(rule.getExtension());
        if (rule.getService() == null) {
            Trace.trace(TRACE_MASKF, ": ADEPT returned NULL service");
            FrameworkLog microCodeEvent = new FrameworkLog(new FrameworkClassLogInfo(92, "04Analysis"), Short.parseShort("0"), 1123, 0);
            microCodeEvent.log();
            Trace.trace(TRACE_MASKT, ": <- HardwareAnalysis04");
            return;
        }
        this.getProblem().setService(rule.getService());
        if (rule.getTransmit() == null) {
            Trace.trace(TRACE_MASKF, ": ADEPT returned NULL transmit.");
            FrameworkLog microCodeEvent = new FrameworkLog(new FrameworkClassLogInfo(92, "04Analysis"), Short.parseShort("0"), 1123, 0);
            microCodeEvent.log();
            Trace.trace(TRACE_MASKT, ": <- HardwareAnalysis04");
            return;
        }
        this.getProblem().setTransmit(rule.isTransmit());
        if (rule.getPriority() == null) {
            Trace.trace(TRACE_MASKF, ": ADEPT returned NULL priority.");
            FrameworkLog microCodeEvent = new FrameworkLog(new FrameworkClassLogInfo(92, "04Analysis"), Short.parseShort("0"), 1123, 0);
            microCodeEvent.log();
            Trace.trace(TRACE_MASKT, ": <- HardwareAnalysis04");
            return;
        }
        this.getIncident().setPriority(rule.getPriorityAsFloat());
        if (rule.getMessages() == null) {
            Trace.trace(TRACE_MASKT, ": ADEPT returned NULL WMS message IDs.");
            FrameworkLog microCodeEvent = new FrameworkLog(new FrameworkClassLogInfo(92, "04Analysis"), Short.parseShort("0"), 1123, 0);
            microCodeEvent.log();
            Trace.trace(TRACE_MASKT, ": <- HardwareAnalysis04");
            return;
        }
        ArrayList messages = rule.getMessageList();
        HardwareAnalysisClass04.setMessages(this.getProblem(), messages);
        this.getProblem().setCategory(1);
        this.getProblem().setDescription(1637);
        Trace.trace(TRACE_MASKF, ": End ff = 0x06");
    }

    private void handleType07() {
        Trace.trace(TRACE_MASKF, ": ff = 0x07");
        this.getProblem().setRefcode("B0002000");
        this.getProblem().setExtension("00000000");
        this.getProblem().setService("S");
        this.getProblem().setTransmit(false);
        this.getIncident().setPriority(72.0f);
        if (this.ourEvent.getTpcptype().substring(0, 1).equals("1")) {
            Trace.trace(TRACE_MASKF, ": Problem is type 1.");
            Trace.trace(TRACE_MASKF, ": Display IQYP0K9 with 7 fields.");
        } else {
            Trace.trace(TRACE_MASKF, ": Problem is type 2.");
            Trace.trace(TRACE_MASKF, ": Display IQYP0K9 with 9 fields.");
        }
        this.getProblem().setCategory(1);
        this.getProblem().setDescription(1637);
        Trace.trace(TRACE_MASKF, ": End ff = 0x07");
    }

    private void handleType08() {
        Trace.trace(TRACE_MASKF, ": ff = 0x08");
        if (this.ourEvent.getTpcCall().indexOf("SSI") != -1) {
            Trace.trace(TRACE_MASKF, ": Caller is SSI.");
            this.getProblem().setService("N");
            Trace.trace(TRACE_MASKF, ": End ff = 0x08.");
            Trace.trace(TRACE_MASKT, ": <- Analysis 04008");
            return;
        }
        Trace.trace(TRACE_MASKF, ": Caller is ROF.");
        String returnCodeValue = new String();
        switch (this.ourEvent.getTpsretc()) {
            case 1: {
                returnCodeValue = "01";
                break;
            }
            case 2: {
                returnCodeValue = "02";
                break;
            }
            case 3: {
                returnCodeValue = "03";
                break;
            }
            case 4: {
                returnCodeValue = "04";
                break;
            }
            case 5: {
                returnCodeValue = "05";
                break;
            }
            case 6: {
                returnCodeValue = "06";
                break;
            }
            case 7: {
                returnCodeValue = "07";
                break;
            }
            case 8: {
                returnCodeValue = "08";
                break;
            }
            case 9: {
                returnCodeValue = "09";
                break;
            }
            case 10: {
                returnCodeValue = "0A";
                break;
            }
            case 11: {
                returnCodeValue = "0B";
                break;
            }
            case 13: {
                returnCodeValue = "0D";
                break;
            }
            case 18: {
                returnCodeValue = "12";
                break;
            }
            case 19: {
                returnCodeValue = "13";
                break;
            }
            case 30: {
                returnCodeValue = "1E";
                break;
            }
            case 32: {
                returnCodeValue = "20";
                break;
            }
            case 33: {
                returnCodeValue = "21";
                break;
            }
            case 35: {
                returnCodeValue = "23";
                break;
            }
            case 37: {
                returnCodeValue = "25";
                break;
            }
            case 38: {
                returnCodeValue = "26";
                break;
            }
            case 39: {
                returnCodeValue = "27";
                break;
            }
            case 40: {
                returnCodeValue = "28";
                break;
            }
            case 41: {
                returnCodeValue = "29";
                break;
            }
            case 42: {
                returnCodeValue = "2A";
                break;
            }
            default: {
                Trace.trace(TRACE_MASKF, ": Invalid error_id value = " + this.ourEvent.getTpsretc());
                FrameworkLog microCodeEvent = new FrameworkLog(new FrameworkClassLogInfo(92, "0408Analysis"), Short.parseShort("0"), 1152, 0);
                microCodeEvent.log();
                Trace.trace(TRACE_MASKT, ": <- Analysis 04008");
                return;
            }
        }
        String baseFilePath = HardwareAnalysisClass04.getBaseFilePath("paconfig");
        String xmlFileToUse = baseFilePath + "IQYP33TP.XML";
        HardwareEvent0408RuleBase rb = new HardwareEvent0408RuleBase();
        try {
            rb = HardwareEvent0408XMLParser.parseXML(xmlFileToUse);
            if (rb != null) {
                Trace.trace(TRACE_MASKD, "have an RB");
            } else {
                Trace.trace(TRACE_MASKD, "do not have an RB");
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKD, "Exception parsing file");
            FrameworkLog microCodeEvent = new FrameworkLog(new FrameworkClassLogInfo(92, "Parsing0406"), Short.parseShort("0"), this.getErrorId(), 0);
            microCodeEvent.log();
            return;
        }
        HardwareEvent0408Rule rule = rb.findRule(returnCodeValue);
        if (rule == null) {
            Trace.trace(TRACE_MASKF, ": ADEPT returned NULL refcode.");
            FrameworkLog microCodeEvent = new FrameworkLog(new FrameworkClassLogInfo(92, "Parsing0406"), Short.parseShort("0"), 1154, 1);
            microCodeEvent.log();
            Trace.trace(TRACE_MASKT, ": <- Analysis 04008");
            return;
        }
        if (rule.getRefCode().equals("B000XXXX")) {
            Trace.trace(TRACE_MASKF, ": Unknown refcode.");
            FrameworkLog microCodeEvent = new FrameworkLog(new FrameworkClassLogInfo(92, "Parsing0406"), Short.parseShort("0"), 1155, 0);
            microCodeEvent.log();
            Trace.trace(TRACE_MASKT, ": <- Analysis 04008");
            return;
        }
        this.getProblem().setRefcode(rule.getRefCode());
        if (rule.getExtension() == null) {
            Trace.trace(TRACE_MASKF, ": ADEPT returned NULL extension");
            FrameworkLog microCodeEvent = new FrameworkLog(new FrameworkClassLogInfo(92, "Parsing0406"), Short.parseShort("0"), 1154, 2);
            microCodeEvent.log();
            Trace.trace(TRACE_MASKT, ": <- Analysis 04008");
            return;
        }
        this.getProblem().setExtension(rule.getExtension());
        this.getIncident().setPriority(rule.getPriorityAsFloat());
        if (rule.getService() == null) {
            Trace.trace(TRACE_MASKF, ": ADEPT returned NULL service");
            FrameworkLog microCodeEvent = new FrameworkLog(new FrameworkClassLogInfo(92, "Parsing0406"), Short.parseShort("0"), 1154, 7);
            microCodeEvent.log();
            Trace.trace(TRACE_MASKT, ": <- Analysis 04008");
            return;
        }
        this.getProblem().setService(rule.getService());
        if (rule.getTransmit() == null) {
            Trace.trace(TRACE_MASKF, ": ADEPT returned NULL transmit.");
            FrameworkLog microCodeEvent = new FrameworkLog(new FrameworkClassLogInfo(92, "Parsing0406"), Short.parseShort("0"), 1154, 8);
            microCodeEvent.log();
            Trace.trace(TRACE_MASKT, ": <- Analysis 04008");
            return;
        }
        this.getProblem().setTransmit(rule.isTransmit());
        if (rule.getMessages() == null) {
            Trace.trace(TRACE_MASKF, ": ADEPT returned NULL WMS message IDs.");
            FrameworkLog microCodeEvent = new FrameworkLog(new FrameworkClassLogInfo(92, "Parsing0406"), Short.parseShort("0"), 1154, 4);
            microCodeEvent.log();
            Trace.trace(TRACE_MASKT, ": <- Analysis 04008");
            return;
        }
        ArrayList messages = rule.getMessageList();
        Trace.trace(TRACE_MASKF, " Messages" + messages.get(0) + " " + messages.get(1) + " " + messages.get(2));
        HardwareAnalysisClass04.setMessages(this.getProblem(), messages);
        this.getProblem().setCategory(1);
        this.getProblem().setDescription(1637);
        Trace.trace(TRACE_MASKF, ": End ff = 0x08");
    }

    private void handleType09() {
        Trace.trace(TRACE_MASKF, ": ff  = 0x09");
        this.getProblem().setRefcode("B0009000");
        this.getProblem().setExtension("00000000");
        this.getProblem().setProblemType("1");
        this.getProblem().setCategory(1);
        this.getProblem().setDescription(1637);
        this.getProblem().setService("N");
        this.getProblem().setTransmit(false);
        this.getProblem().addProblemStatement(new BaseMessageText("XPA2403"));
        this.getProblem().addRepairImpactStatement(new BaseMessageText("XPA2439"));
        this.getProblem().addCorrectiveActionStatement(new BaseMessageText("XPA2901"));
        this.getIncident().setPriority(64.0f);
        Trace.trace(TRACE_MASKF, ": End ff = 0x09");
    }

    private void handleType0B() {
        Trace.trace(TRACE_MASKF, ": ff = 0x0B");
        if (this.getErrorReason() > 0) {
            this.getProblem().setRefcode("B000B001");
        } else {
            this.getProblem().setRefcode("B000B000");
        }
        this.getProblem().setExtension("00000000");
        this.getProblem().setService("Q");
        this.getProblem().setCategory(3);
        this.getProblem().setDescription(1643);
        this.getProblem().setTransmit(true);
        this.getIncident().setPriority(66.0f);
        this.getProblem().addProblemStatement(new BaseMessageText("XPA2212"));
        this.getProblem().addCorrectiveActionStatement(new BaseMessageText("XPA2239"));
        this.getProblem().addCorrectiveActionStatement(new BaseMessageText("XPA2243"));
        this.getProblem().addCorrectiveActionStatement(new BaseMessageText("XPA2244"));
        this.getProblem().addCorrectiveActionStatement(new BaseMessageText("XPA2902"));
        Trace.trace(TRACE_MASKF, ": End ff = 0x0B");
    }
}

